/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "platform.h"

/* Platform diagnostic test table */
diagTestTable_t gDiagTestTable[PLATFORM_TEST_COUNT] =
{
		{"Auto Run All Tests",NULL, NULL, 0, 0},
		{"NAND Flash Test",nandflash_test,NULL,0,0},
		{"DDR Test", ddr3_test,NULL, 0, 0},
		{"USB Test", usb_test,NULL, 0, 0},
		{"LED Test", led_test,NULL, 0, 0},
		{"SD Card Test", SD_test,NULL, 0, 0},
		{"WLAN Test", wlan_test,NULL, 0, 0},
		{"Bluetooth Test", bluetooth_test,NULL, 0, 0},
		{"Audio Test", aic3104_tests,1, 0, 0},
		{"Switch Test", switch_test,NULL, 0, 0},
		{"Ethernet Test", emac_gmii_test,NULL, 0, 0},
		{"Camera Test", camera_test,NULL,0,0}
};
